/*****************************************************************************/
/* FILE NAME: main.c                            COPYRIGHT (c) Freescale 2010 */
/*                                                       All Rights Reserved */
/*  									     								 */
/* MPC5668 Example Projects Suite					     					 */
/* PIT Examples							            						 */
/*									    									 */
/* Revision History														     */
/*      Rev: 1.0 		Author:	Martin Vaupel	DATE: 19/10/2010    		 */
/*									     									 */
/*																			 */
/* Example demonstrates the functionality of the periodic interrup timer	 */ 
/* (PIT) and the interrupt controller (INTC). While LED1 is toggled in the	 */
/* main loop a periodic interrupt will occur. In its ISR LED2 is toggled	 */
/* 5 times while LED1 is frozen. 											 */	
/*****************************************************************************/
#include "mpc5668.h"

  uint32_t count; 
  
void PITinit(void);

/********************************** main *************************************/
void main (void) 
{
	SIU.SYSCLK.B.SYSCLKSEL = 0x1;	/* Select crystal as CLK Source - 40MHz */

	SIU.PCR[64].R=0x0200;			/* OBE on PE0 - LED connection */
	SIU.PCR[65].R=0x0200;			/* OBE on PE1 - LED connection */

	xcptn_xmpl();					/* Initialize IVPR, IVOR, INTC and priorities */
	enableIrq();					/* Enable Interrupts in INTC and core */
	PITinit();						/* Initialize PIT */
	
	while(1)
	{   
		for (count=0; count<100000; count++);	/* loops to toggle PE0 */
		SIU.GPDO[64].R = 0x01;
		for (count=0; count<100000; count++);
		SIU.GPDO[64].R = 0x00;
    } 
}/* end of main() */	

void PITinit(void)				/* Initializes PIT channel 1 */
{
	PIT.MCR.B.MDIS = 0; 		/* enable PIT */
	PIT.MCR.B.FRZ = 1; 			/* freeze timer in debug mode */
	
	PIT.LDVAL1.R = 0x03FFFFFF;  /* load start value for timer1 */
								/* will generate interrupt every 5 secs */
	
	PIT.TCTRL1.B.TIE = 1; 		/* enable timer1 interrupts */
	PIT.TCTRL1.B.TEN = 1; 		/* timer1 active */
	
	PIT.TFLG1.B.TIF = 1;		/* clear interrupt flag */
}